# читаємо вхід
import sys
input = sys.stdin.readline

n = int(input().strip())
nums = input().split()
# nums — список рядків (десяткових представлень). Вони всі різні.

# мапа: рядок -> індекс
idx = {s: i for i, s in enumerate(nums)}

parent = [-1] * n
children = [[] for _ in range(n)]

# знайдемо для кожного числа найближчий (найдовший) наявний префікс
for i, s in enumerate(nums):
    # відкидаємо по одній цифрі справа, поки не знайдемо префікс у idx або поки не стане довжина 0
    for L in range(len(s) - 1, 0, -1):
        p = s[:L]
        if p in idx:
            parent[i] = idx[p]
            children[parent[i]].append(i)
            break
    # якщо не знайдено — parent[i] залишається -1

# знайдемо листки (вузли без дітей)
leaves = [i for i in range(n) if len(children[i]) == 0]

used = [False] * n
groups = []

# для кожного листка піднімаємось вгору, поки не натрапимо на вже використаний вузол
for leaf in leaves:
    cur = leaf
    group = []
    while cur != -1 and not used[cur]:
        group.append(cur)
        used[cur] = True
        cur = parent[cur]
    groups.append(group)


for i in range(n):
    if not used[i]:
        groups.append([i])
        used[i] = True

# Вивід
k = len(groups)
print(k)
for g in groups:
    print(len(g))
    print(" ".join(nums[i] for i in g))
